% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_pmol.R
\name{predict_pmol}
\alias{predict_pmol}
\title{predict picomoles of DNA from a fit and read counts (coverage)}
\usage{
predict_pmol(
  fit,
  genomic_gr,
  bsgenome = NULL,
  ret = c("gr", "df"),
  slide = FALSE
)
}
\arguments{
\item{fit}{result of model_glm_pmol}

\item{genomic_gr}{the genomic data / new data}

\item{bsgenome}{BSgenome name (if null, will guess from genomic_gr)}

\item{ret}{return a data.frame ("df") or GRanges ("gr")?  ("gr")}

\item{slide}{compute a sliding window estimate for GCfrac (1/3 width)?}
}
\value{
object with read count, fraglen, GC\%, CpG**(1/3), and concentration
}
\description{
FIXME: this could be made MUCH faster by precomputing CpG/GC stats per bin
}
\details{
Using GRanges as the return value is (perhaps counterintuitively) \emph{much}
faster than the data.frame, since the sequence of the bins gets converted
from a BSgenome representation to characters in the latter (it is implied
by the bin start, stop, and genome when left as a GRanges).
}
\examples{

data(spike_res)
data(genomic_res)
data(spike, package="spiky")
fit <- model_glm_pmol(covg_to_df(spike_res, spike=spike),spike=spike)
preddf <- predict_pmol(fit, genomic_res, ret="df")
pred <- predict_pmol(fit, genomic_res, ret="gr")
bin_pmol(pred)

}
