% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_glm_pmol.R
\name{model_glm_pmol}
\alias{model_glm_pmol}
\title{Build a generalized linear model from spike-ins to correct bias in cfMeDIP}
\usage{
model_glm_pmol(x, spike, conc = NULL, ...)
}
\arguments{
\item{x}{data w/frag_grp, id, and read_count; or scan_spiked_bam result}

\item{spike}{spike database, e.g. \code{data(spike, package='spiky')}}

\item{conc}{concentration for each spike (will be referenced if NULL)}

\item{...}{other arguments to pass to \code{glm} (e.g. \code{family})}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   the model fit for the data
}\if{html}{\out{</div>}}
}
\description{
formerly '2020_model_glm_fmol'.  Note that everything in x can be had from
a BAM/CRAM with spike contigs named as frag_grp (len_CpGs_GC) in the index
and in fact that is what scan_spiked_bam now does.
}
\examples{

data(spike, package="spiky")

data(spike_read_counts, package="spiky")
fit1 <- model_glm_pmol(spike_read_counts, spike=spike)

data(spike_res) # scan_spiked_bam result
fit2 <- model_glm_pmol(spike_res, spike=spike)

}
