% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spike_depth.R
\name{get_spike_depth}
\alias{get_spike_depth}
\title{get the (max, median, or mean) coverage for spike-in contigs from a BAM/CRAM}
\usage{
get_spike_depth(covg, spike_gr = NULL, spike = NULL, how = c("max", "mean"))
}
\arguments{
\item{covg}{the coverage RleList}

\item{spike_gr}{the spike-in GRanges (default: figure out from seqinfo)}

\item{spike}{information about the spikes (default: load \code{spike})}

\item{how}{how to summarize the per-spike coverage (max)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     a GRanges with summarized coverage and features for each
}\if{html}{\out{</div>}}
}
\description{
get the (max, median, or mean) coverage for spike-in contigs from a BAM/CRAM
}
\examples{
sb <- system.file("extdata", "example.spike.bam", package="spiky",
                  mustWork=TRUE)
data(spike, package="spiky")
si <- seqinfo_from_header(sb)
genome(si) <- "spike"
mgr <- get_merged_gr(si,spike=spike)

fl <- scanBamFlag(isDuplicate=FALSE, isPaired=TRUE, isProperPair=TRUE)
bp <- ScanBamParam(flag=fl)
bamMapqFilter(bp) <- 20

covg <- get_spiked_coverage(sb, bp=bp, gr=mgr)
get_spike_depth(covg, spike_gr=mgr, spike=spike)

}
