% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_spike_contigs.R
\name{find_spike_contigs}
\alias{find_spike_contigs}
\title{find spike-in seqlevels in an object \code{x}, where !is.null(seqinfo(x))}
\usage{
find_spike_contigs(x, spike)
}
\arguments{
\item{x}{something with seqlevels}

\item{spike}{a DataFrame with spike-in information}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   indices of which contigs in seqlevels(x) are spike-in contigs
}\if{html}{\out{</div>}}
}
\description{
Find the spike-like contigs in a BAM with both natural and spiked contigs.
This started out as glue in some other functions and got refactored out.
}
\details{
The indices have an attribute "mappings", which is a character vector
such that attr(find_spike_contigs(x), "mappings") == standardized
for all contig names in the CRAM/BAM/whatever, and standardized is
the rowname in \code{spike} that corresponds to the original contig name.
}
\examples{
sb <- system.file("extdata", "example.spike.bam", package="spiky",
                  mustWork=TRUE)
si <- seqinfo_from_header(sb)
data(spike, package="spiky")
find_spike_contigs(si, spike=spike)

}
\seealso{
get_base_name

rename_spike_seqlevels
}
