% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateBetaParamsFromCounts.R
\name{estimateBetaParamsFromCounts}
\alias{estimateBetaParamsFromCounts}
\title{Estimate parameters of a Beta distribution from counts}
\usage{
estimateBetaParamsFromCounts(x)
}
\arguments{
\item{x}{a matrix of counts}
}
\value{
outputs a list object with the following components
\item{n }{Normalised library size}
\item{alpha }{a vector of alpha parameters for the Beta distribution for 
each cell type}
\item{beta }{vector of beta parameters for the Beta distribution for 
each cell type}
\item{pi }{Estimate of the true proportion for each cell type}
\item{dispersion }{Dispersion estimates for each cell type}
\item{var }{Variance estimates for each cell type}
}
\description{
This function estimates the two parameters of the Beta distribution, alpha
and beta for each cell type. The input is a matrix of cell type counts, 
where the rows are the cell types/clusters and the columns are the samples.
}
\details{
This function is called from the plotting function \code{plotCellTypeMeanVar}
in order to estimate the variance for the Beta-Binomial distribution for 
each cell type.
}
\examples{
data <- speckle_example_data()
x <- table(data$clusters, data$samples)
estimateBetaParamsFromCounts(x)


}
\author{
Belinda Phipson
}
