% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_motifs.R
\name{scan_motifs}
\alias{scan_motifs}
\title{Scans interaction file for motif instances}
\usage{
scan_motifs(int_data, motifs, genome)
}
\arguments{
\item{int_data}{a \code{\link[GenomicInteractions]{GenomicInteractions}}
object of paired genomic regions}

\item{motifs}{a TFBS tools matrix of DNA binding motifs}

\item{genome}{BSgenome object or DNAStringSet object, must match chromosomes
from interaction data file}
}
\value{
an interaction data object where \code{obj$anchor1_motifs} and
\code{obj$anchor2_motifs} contain information about the scores and matches
to motifs from anchor one and anchor two of interaction data genomic regions
}
\description{
Uses motifmatchR to scan interaction regions for given motifs.
}
\examples{
\dontrun{
genome_id <- "BSgenome.Mmusculus.UCSC.mm9"
if (!(genome_id \%in\% rownames(utils::installed.packages()))) {
  BiocManager::install(genome_id, update = FALSE, ask = FALSE)
}
genome <- BSgenome::getBSgenome(genome_id)

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")

yy1_pd_interaction <- scan_motifs(spatzie::interactions_yy1, motifs, genome)
}

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")
left <- GenomicRanges::GRanges(
  seqnames = c("chr1", "chr1", "chr1"),
  ranges = IRanges::IRanges(start = c(1, 15, 20),
                            end = c(10, 35, 31)))
right <- GenomicRanges::GRanges(
  seqnames = c("chr1", "chr2", "chr2"),
  ranges = IRanges::IRanges(start = c(17, 47, 41),
                            end = c(28, 54, 53)))
test_interactions <- GenomicInteractions::GenomicInteractions(left, right)

# toy DNAStringSet to replace BSgenome object
seqs <- c("chr1" = "CCACTAGCCACGCGTCACTGGTTAGCGTGATTGAAACTAAATCGTATGAAAATCC",
          "chr2" = "CTACAAACTAGGAATTTAGGCAAACCTGTGTTAAAATCTTAGCTCATTCATTAAT")
toy_genome <- Biostrings::DNAStringSet(seqs, use.names = TRUE)

res <- scan_motifs(test_interactions, motifs, toy_genome)

}
\author{
Jennifer Hammelman
}
