% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_motif_occurrence.R
\name{plot_motif_occurrence}
\alias{plot_motif_occurrence}
\title{Plot motif occurrence}
\usage{
plot_motif_occurrence(
  interaction_data,
  method = c("counts", "instances", "scores")
)
}
\arguments{
\item{interaction_data}{an interactionData object of paired genomic regions}

\item{method}{way to interpret motif matching for each anchor region as
"counts" number of motifs per region, "instances" motif
present or absent each region, or "scores" maximum motif PWM
match score for each region}
}
\value{
plot containing histogram for each anchor
}
\description{
Plots a histogram of motif values (either counts, instances, or scores)
for anchor 1 and anchor 2 regions.
}
\examples{
\dontrun{
genome_id <- "BSgenome.Mmusculus.UCSC.mm9"
if (!(genome_id \%in\% rownames(utils::installed.packages()))) {
  BiocManager::install(genome_id, update = FALSE, ask = FALSE)
}
genome <- BSgenome::getBSgenome(genome_id)

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")

yy1_pd_interaction <- scan_motifs(spatzie::interactions_yy1, motifs, genome)
yy1_pd_interaction <- filter_motifs(yy1_pd_interaction, 0.4)
plot_motif_occurrence(yy1_pd_interaction,"counts")
}

plot_motif_occurrence(spatzie::anchor_pair_example_score)

}
\author{
Jennifer Hammelman
}
