% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_specific_interactions.R
\name{get_specific_interactions}
\alias{get_specific_interactions}
\title{Get interactions that contain a specific motif pair}
\usage{
get_specific_interactions(
  interaction_data,
  anchor1_motif = NULL,
  anchor2_motif = NULL
)
}
\arguments{
\item{interaction_data}{an interactionData object of paired genomic regions}

\item{anchor1_motif}{Motif name from \code{interactionData$anchor1_motifs}}

\item{anchor2_motif}{Motif name from \code{interactionData$anchor2_motifs}}
}
\value{
a \code{\link[GenomicInteractions]{GenomicInteractions}} object
containing a subset subset of interactions that contain an instance of
\code{anchor1_motif} in anchor 1 and \code{anchor2_motif} in anchor 2
}
\description{
Select interactions that contain anchor1_motif within anchor 1 and
anchor2_motif within anchor 2.
}
\examples{
\dontrun{
genome_id <- "BSgenome.Mmusculus.UCSC.mm9"
if (!(genome_id \%in\% rownames(utils::installed.packages()))) {
  BiocManager::install(genome_id, update = FALSE, ask = FALSE)
}
genome <- BSgenome::getBSgenome(genome_id)

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")

yy1_pd_interaction <- scan_motifs(spatzie::interactions_yy1, motifs, genome)
yy1_pd_interaction <- filter_motifs(yy1_pd_interaction, 0.4)
yy1_pd_count_corr <- anchor_pair_enrich(yy1_pd_interaction,
                                        method = "score")
yy1_yy1_interactions <- get_specific_interactions(
  yy1_pd_interaction,
  anchor1_motif = "YY1",
  anchor2_motif = "YY1")
}

res <- get_specific_interactions(spatzie::int_data_yy1,
                                 anchor1_motif = "YY1",
                                 anchor2_motif = "YY1")

}
\author{
Jennifer Hammelman
}
