% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_pair_motifs.R
\name{filter_pair_motifs}
\alias{filter_pair_motifs}
\title{Filter significant motif interactions}
\usage{
filter_pair_motifs(interaction_data, method = "fdr", threshold = 0.05)
}
\arguments{
\item{interaction_data}{an interactionData object of paired genomic regions}

\item{method}{statistical method for multiple hypothesis correction,
defaults to Benjamini-Hochberg (\code{"fdr"}) (see
\code{\link[stats]{p.adjust}} for options)}

\item{threshold}{p-value threshold for significance cut-off}
}
\value{
an interactionData object where \code{obj$pair_motif_enrich} contains
multiple hypothesis corrected p-values for significance of seeing a
higher co-occurrence than what we get by chance and
\code{obj$pair_motif_enrich_sig} contains only motifs that have at least one
significant interaction.
}
\description{
Multiple hypothesis correction applied to filter for significant motif
interactions.
}
\examples{
\dontrun{
genome_id <- "BSgenome.Mmusculus.UCSC.mm9"
if (!(genome_id \%in\% rownames(utils::installed.packages()))) {
  BiocManager::install(genome_id, update = FALSE, ask = FALSE)
}
genome <- BSgenome::getBSgenome(genome_id)

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")

yy1_pd_interaction <- scan_motifs(spatzie::interactions_yy1, motifs, genome)
yy1_pd_interaction <- filter_motifs(yy1_pd_interaction, 0.4)
yy1_pd_score_corr <- anchor_pair_enrich(yy1_pd_interaction, method = "score")
yy1_pd_score_corr_adj <- filter_pair_motifs(yy1_pd_score_corr)
}

res <- filter_pair_motifs(spatzie::anchor_pair_example_count,
                          threshold = 0.5)

}
\author{
Jennifer Hammelman
}
