% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_motifs.R
\name{filter_motifs}
\alias{filter_motifs}
\title{Filter motifs based on occurrence within interaction data}
\usage{
filter_motifs(interaction_data, threshold)
}
\arguments{
\item{interaction_data}{an interactionData object of paired genomic regions}

\item{threshold}{fraction of interactions that should contain a motif for a
motif to be considered}
}
\value{
an interactionData object where \code{obj$anchor1_motif_indices}
and \code{obj$anchor2_motif_indices} have been filtered to motifs that are
present in a threshold fraction of interactions
}
\description{
Select a subset of motifs that are in at least a threshold fraction of
regions. Motif subsets are selected separately for anchor one and anchor
two regions.
}
\examples{
\dontrun{
genome_id <- "BSgenome.Mmusculus.UCSC.mm9"
if (!(genome_id \%in\% rownames(utils::installed.packages()))) {
  BiocManager::install(genome_id, update = FALSE, ask = FALSE)
}
genome <- BSgenome::getBSgenome(genome_id)

motifs_file <- system.file("extdata/motifs_subset.txt.gz",
                           package = "spatzie")
motifs <- TFBSTools::readJASPARMatrix(motifs_file, matrixClass = "PFM")

yy1_pd_interaction <- scan_motifs(spatzie::interactions_yy1, motifs, genome)
yy1_pd_interaction <- filter_motifs(yy1_pd_interaction, 0.4)
}

res <- filter_motifs(spatzie::scan_interactions_example, threshold = 0.1)

}
\author{
Jennifer Hammelman
}
