% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_motif_pairs.R
\name{compare_motif_pairs}
\alias{compare_motif_pairs}
\title{Compare pairs of motifs between two interaction datasets}
\usage{
compare_motif_pairs(
  interaction_data1,
  interaction_data2,
  differential_p = 0.05
)
}
\arguments{
\item{interaction_data1}{an interactionData object of paired genomic regions
that has been scanned for significant motif:motif
interactions}

\item{interaction_data2}{an interactionData object of paired genomic regions
that has been scanned for significant motif:motif
interactions}

\item{differential_p}{threshold for significance of differential p-value}
}
\value{
a matrix of the log likelihood ratio of motif pairs that are
        significantly differential between two interactionData sets
}
\description{
Compute the log-likelihood ratio that a motif pair is differential between
two interaction datasets. Note that motif pair significance should have
been computed using the same method for both datasets.
}
\examples{
pheatmap::pheatmap(compare_motif_pairs(spatzie::int_data_k562,
                                       spatzie::int_data_mslcl, 5e-06),
                   fontsize = 6)
}
\author{
Jennifer Hammelman
}
