#' Function to extract nearest genes.
#'
#' Given a vector of target gene identifiers, this function selects genes with similar expression profiles for every target gene. The selection is based on correlation matrix or distance matrix generated by \code{\link[stats]{cor}} or \code{\link[stats]{dist}} from the "stats" package respectively. The argument \code{p} sets the proportion of top most similar genes. Only genes within this proportion are selected.   
#' @param mat The correlation or distance matrix.
#' @inheritParams submatrix
#' @return A vector of target genes and their nearest neighbors.
#' @keywords Internal
#' @noRd

#' @author Jianhai Zhang \email{jzhan067@@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@@ucr.edu}

sub_na <- function(mat, ID, p=0.3, n=NULL, v=NULL) {

  len <- nrow(mat); na <- NULL; for (i in ID) {

    if (!is.null(p)) {
  
      vec <- sort(mat[, i]); thr <- vec[len-floor(len*p)+1]
      na0 <- names(vec[vec >= thr]); na <- c(na, na0)

    } else if (!is.null(n)) {

      vec <- sort(mat[, i]); thr <- vec[len-n+1]
      na0 <- names(vec[vec >= thr]); na <- c(na, na0)

    } else if (!is.null(v)) {
  
      vec <- mat[, i]; na0 <- names(vec[vec >= v]); na <- c(na, na0)

    }

  }; na <- unique(na); return(na)

}


