% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPca.R
\name{plotFpca}
\alias{plotFpca}
\title{Plot a biplot from an fPCA analysis}
\usage{
plotFpca(data, res, colourby = NULL, labelby = NULL)
}
\arguments{
\item{data}{a data object for functional data analysis containing at least
the functional response $Y$.}

\item{res}{the output from the fPCA calculation}

\item{colourby}{the variable by which to colour the PCA plot by}

\item{labelby}{the variable by which to label the PCA plot by}
}
\value{
a list with components of fpca.face
}
\description{
A function that takes the output from the \code{functionalPCA} function and
returns a \code{ggplot} object of the first two dimensions of the PCA as biplot.
}
\examples{
# load the pancreas dataset
library("tidyr")
library("stringr")
library("dplyr")
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
# calculate the Gcross metric for alpha and beta cells
metricRes <- calcMetricPerFov(spe, c("alpha", "beta"),
    subsetby = "image_number", fun = "Gcross",
    marks = "cell_type", rSeq = seq(0, 50, length.out = 50),
    c("patient_stage", "patient_id", "image_number"), ncores = 1
)
metricRes$ID <- paste0(
  metricRes$patient_stage, "|", metricRes$patient_id,
  "|", metricRes$image_number
)

# prepare data for FDA
dat <- prepData(metricRes, "r", "rs")

# drop rows with NA
dat <- dat |> drop_na()
# create meta info of the IDs
splitData <- str_split(dat$ID, "|")
dat$condition <- factor(sapply(splitData, function(x) x[1]))
dat$patient_id <- factor(sapply(splitData, function(x) x[2]))
dat$image_id <- factor(sapply(splitData, function(x) x[3]))
# calculate fPCA
mdl <- functionalPCA(
    data = dat, r = metricRes$r |> unique()
)
p <- plotFpca(
    data = dat, res = mdl, colourby = "condition",
    labelby = "patient_id"
)
print(p)
}
