% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMetric.R
\name{.extractMetric}
\alias{.extractMetric}
\title{Compute a spatial metric on a SpatialExperiment object}
\usage{
.extractMetric(
  df,
  selection,
  fun,
  marks = NULL,
  rSeq = NULL,
  by = NULL,
  continuous = FALSE,
  window = NULL,
  ...
)
}
\arguments{
\item{df}{A \code{dataframe} with the x and y coordinates from the corresponding
\code{SpatialExperiment} and the \code{colData}}

\item{selection}{the mark(s) you want to compare}

\item{fun}{the \code{spatstat} function to compute on the point pattern object}

\item{marks}{the marks to consider e.g. cell types}

\item{rSeq}{the range of r values to compute the function over}

\item{by}{the spe \code{colData} variable(s) to add to the meta data}

\item{continuous}{A boolean indicating whether the marks are continuous
defaults to FALSE}

\item{window}{a observation window for the point pattern of class \code{owin}.}

\item{...}{Other parameters passed to \code{spatstat.explore} functions}
}
\value{
a \code{spatstat} metric object with the fov number, the number of
points and the centroid of the image
}
\description{
A function that takes a \code{SpatialExperiment} object and computes a spatial
statistics function as implemented in \code{spatstat}. The output is a \code{spatstat}
object.
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
speSub <- subset(spe, , image_number == "138")
dfSub <- .speToDf(speSub)
metricRes <- .extractMetric(dfSub, c("alpha", "Tc"),
    fun = "Gcross",
    marks = "cell_type", rSeq = seq(0, 50, length.out = 50),
    by = c("patient_stage", "patient_id", "image_number")
)
}
