% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.dfToppp}
\alias{.dfToppp}
\title{Convert SpatialExperiment object to ppp object}
\usage{
.dfToppp(df, marks = NULL, continuous = FALSE, window = NULL)
}
\arguments{
\item{df}{A dataframe with the x and y coordinates from the corresponding
SpatialExperiment and the ColData}

\item{marks}{A vector of marks to be associated with the points, has to be
either named 'cell_type' if you want to compare discrete celltypes or else
continous gene expression measurements are assumed as marks.}

\item{continuous}{A boolean indicating whether the marks are continuous
defaults to FALSE}

\item{window}{An observation window of the point pattern of class \code{owin}.}
}
\value{
A ppp object for use with \code{spatstat} functions
}
\description{
Convert SpatialExperiment object to ppp object
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
speSub <- subset(spe, , image_number == "138")
dfSub <- .speToDf(speSub)
pp <- .dfToppp(dfSub, marks = "cell_type")

}
