% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveDE.R
\name{stabilize}
\alias{stabilize}
\title{Stabilize variance of counts}
\usage{
stabilize(counts)
}
\arguments{
\item{counts}{\code{matrix} with expression values for samples in
columns and genes in rows.}
}
\value{
\code{matrix} of variance stabilized counts.
}
\description{
Stabilize variance of negative binomial data using Anscombe's approximation.
This function is a wrapper for \code{stabilize} from the
\href{https://github.com/Teichlab/NaiveDE}{NaiveDE} Python package.
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
mock <- mockSVG(20, 3, 1)

stabilized <- stabilize(mock$counts)
}
