% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveDE.R
\name{regress_out}
\alias{regress_out}
\title{Regress out library size effect}
\usage{
regress_out(counts, sample_info)
}
\arguments{
\item{counts}{\code{matrix} of variance stabilized
counts, e.g. resulting from \code{\link[=stabilize]{stabilize()}}.}

\item{sample_info}{\code{data.frame} with samples as rows and at least a column
with \code{total_counts}.}
}
\value{
\code{matrix} of normalized counts.
}
\description{
Regresses out the effect of library size.
This function is a wrapper for \code{regress_out} from the
\href{https://github.com/Teichlab/NaiveDE}{NaiveDE} Python package.
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
mock <- mockSVG(20, 3, 1)

stabilized <- stabilize(mock$counts)
sample_info <- mock$coordinates
sample_info$total_counts <- colSums(mock$counts)

regressed <- regress_out(counts = stabilized, sample_info = sample_info)
}
