% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{multiGenePlots}
\alias{multiGenePlots}
\alias{multiGenePlots,matrix-method}
\alias{multiGenePlots,SpatialExperiment-method}
\title{Plot Spatial Patterns of Multiple Genes}
\usage{
multiGenePlots(x, ...)

\S4method{multiGenePlots}{matrix}(
  x,
  coordinates,
  genes_plot,
  viridis_option = "D",
  ncol = 2,
  point_size = 1,
  dark_theme = TRUE
)

\S4method{multiGenePlots}{SpatialExperiment}(
  x,
  assay_type = "counts",
  genes_plot,
  viridis_option = "D",
  ncol = 2,
  point_size = 1,
  dark_theme = TRUE
)
}
\arguments{
\item{x}{A numeric \code{matrix} of stabilized counts (e.g. resulting from
\code{\link[=stabilize]{stabilize()}}) where genes are rows and cells are columns.

Alternatively, a \linkS4class{SpatialExperiment} object.}

\item{...}{For the generic, arguments to pass to specific methods.}

\item{coordinates}{A \code{data.frame} with sample coordinates. Each row is a
sample, the columns with coordinates should be named 'x' and 'y'.

For the \emph{SpatialExperiment} method, coordinates are taken from
\code{spatialCoords(x)}.}

\item{genes_plot}{character vector specifying which genes are to be plotted.}

\item{viridis_option}{This function uses the \code{viridis} palette to color
cells for gene expression. Four options are available: "magma" (or "A"),
"inferno" (or "B"), "plasma" (or "C"),
"viridis" (or "D", the default option) and "cividis" (or "E").}

\item{ncol}{Number of columns to arrange the plots.}

\item{point_size}{Point size of each plot.}

\item{dark_theme}{Whether dark background should be used; this is helpful to
highlight cells with high expression when using the \code{viridis} palette.}

\item{assay_type}{A \code{character} string specifying the assay from \code{x} to use
as input. Defaults to \code{"counts"}.}
}
\value{
This function draws a plot for each specified genes
}
\description{
Plot Spatial Patterns of Multiple Genes
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
spe <- mockSVG(size = 20, tot_genes = 3, de_genes = 1, return_SPE = TRUE)

## Run spatialDE
results <- spatialDE(spe)

ordered_spe_results <- results[order(results$qval), ]
head(ordered_spe_results)

plots <- multiGenePlots(spe,
    assay_type = "counts",
    ordered_spe_results$g,
    point_size = 4,
    viridis_option = "D"
)

}
\references{
Svensson, V., Teichmann, S. & Stegle, O. SpatialDE: identification of
spatially variable genes. Nat Methods 15, 343–346 (2018).
\url{https://doi.org/10.1038/nmeth.4636}

\href{https://pypi.org/project/SpatialDE/1.1.3/}{\strong{SpatialDE 1.1.3}}: the version
of the Python package used under the hood.
}
\seealso{
The individual steps performed by this function: \code{\link[=stabilize]{stabilize()}},
\code{\link[=spatialDE]{spatialDE()}}.

For further analysis of the DE results:
\code{\link[=model_search]{model_search()}} and \code{\link[=spatial_patterns]{spatial_patterns()}}.
}
\author{
Davide Corso, Milan Malfait, Lambda Moses
}
