% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msearch.R
\name{modelSearch}
\alias{modelSearch}
\alias{modelSearch,matrix-method}
\alias{modelSearch,SpatialExperiment-method}
\title{Classify Spatially Variable Genes to interpretable fitting classes}
\usage{
modelSearch(x, de_results, ...)

\S4method{modelSearch}{matrix}(x, de_results, coordinates, qval_thresh = 0.05, verbose = FALSE)

\S4method{modelSearch}{SpatialExperiment}(
  x,
  de_results,
  assay_type = "counts",
  qval_thresh = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{x}{A numeric \code{matrix} of counts where genes are rows and cells are columns.

Alternatively, a \linkS4class{SpatialExperiment} object.}

\item{de_results}{\code{data.frame} resulting from \code{\link[=run]{run()}} or \code{\link[=spatialDE]{spatialDE()}}.}

\item{...}{For the generic, arguments to pass to specific methods.}

\item{coordinates}{A \code{data.frame} with sample coordinates. Each row is a
sample, the columns with coordinates should be named 'x' and 'y'.

For the \emph{SpatialExperiment} method, coordinates are taken from
\code{spatialCoords(x)}.}

\item{qval_thresh}{\code{numeric} scalar, specifying the q-value significance
threshold to filter \code{de_results}. Only rows in \code{de_results} with
\code{qval < qval_thresh} will be kept. To disable, set \code{qval_thresh = NULL}.}

\item{verbose}{A \code{logical} controlling the display of a progress bar from the
Python package.}

\item{assay_type}{A \code{character} string specifying the assay from \code{x} to use
as input. Defaults to \code{"counts"}.}
}
\value{
\code{data.frame} of model_search results.
}
\description{
Compare model fits with different models, using the
\href{https://github.com/Teichlab/SpatialDE}{\strong{SpatialDE}} Python package.
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
spe <- mockSVG(size = 20, tot_genes = 3, de_genes = 1, return_SPE = TRUE)

## Run spatialDE with S4 integration
de_results <- spatialDE(spe)

## Run model search
model_search <- modelSearch(spe, de_results = de_results,
    qval_thresh = NULL, verbose = FALSE
)

}
\references{
Svensson, V., Teichmann, S. & Stegle, O. SpatialDE: identification of
spatially variable genes. Nat Methods 15, 343–346 (2018).
\url{https://doi.org/10.1038/nmeth.4636}

\href{https://pypi.org/project/SpatialDE/1.1.3/}{\strong{SpatialDE 1.1.3}}: the version
of the Python package used under the hood.
}
\seealso{
The individual steps performed by this function: \code{\link[=stabilize]{stabilize()}},
\code{\link[=regress_out]{regress_out()}} and \code{\link[=model_search]{model_search()}}.
}
\author{
Davide Corso, Milan Malfait, Lambda Moses
}
