% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{plot_roc}
\alias{plot_roc}
\title{The plot_roc() function}
\usage{
plot_roc(result_assessment, group = TRUE, ngroup = 0, est_names)
}
\arguments{
\item{result_assessment}{It is the list result from function
path_result_for_roc() which has five-dimensions recording
the path number (i.e. the order of \eqn{\lambda} ), the sensitivity,
the specificity, the Negative predicted value (NPV) and
the Positive predicted value (PPV) respectively.}

\item{group}{It is a logical parameter indicating if the result_assessment
is for several GGM models. When it is TRUE,
it produceS the ROC from several GGM models. when it is FALSE, it only
produces a ROC for one model.}

\item{ngroup}{It is an  integer recording the number of models when group
is TRUE.}

\item{est_names}{it is used for labeling the GGM model in legend of ROC
curve.}
}
\value{
Return the plot of Receiver Operational Curve
}
\description{
The plot_roc function is designed to produce the Receiver
Operative Characteristics (ROC) Curve for visualizing the prediction 
accuracy of a Gaussian Graphical model (GGM) to the true graph structure. 
The GGM must use a l-p norm regularizations (p=1,2) with the series of 
solutions conditional on the regularization parameter.
}
\examples{
prec1 <- matrix(c(0,2,3,1,0,0.5,0,0,0.4),nrow=3,ncol=3)
Omega_est <- array(dim=c(3,3,3))
Omega_est[,,1] <- matrix(c(1,1,1,0.2,0.5,0.2,2,0.2,0.3),nrow=3,ncol=3)
Omega_est[,,2] <- matrix(c(0,1,1,1,0,0,0,0,1),nrow=3,ncol=3)
Omega_est[,,3] <- matrix(c(0,0,0,0,0,0,0,0,0),nrow=3,ncol=3)
roc_path_result <- path_result_for_roc(PREC_for_graph=prec1,
OMEGA_path=Omega_est,pathnumber=3)
plot_roc(result_assessment=roc_path_result,group=FALSE,ngroup=0,
est_names='test example')


}
