% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Create an interactive volcano plot}
\usage{
volcanoPlot(
  x,
  stats = "dge",
  xaxis = "logFC",
  yaxis = "pval",
  idx,
  xtfrm = base::identity,
  ytfrm = function(vals) -log10(vals),
  xlab = xaxis,
  ylab = sprintf("-log10(\%s)", yaxis),
  highlight = NULL,
  horiz_line = c(padj = 0.1),
  xhex = NULL,
  yhex = NULL,
  width = NULL,
  height = NULL,
  shiny_source = "mgvolcano",
  ggtheme = ggplot2::theme_bw(),
  ...
)
}
\arguments{
\item{x}{A \code{SparrowResult} object, or a \code{data.frame}}

\item{stats}{One of \code{"dge"} or \code{resultNames(x)}}

\item{xaxis, yaxis}{the column of the the provided (or extracted)
\code{data.frame} to use for the xaxis and yaxis of the volcano}

\item{idx}{The column of the \code{data.frame} to use as the identifier
for the element in the row. You probably don't want to mess with this}

\item{xtfrm}{A function that transforms the \code{xaxis} column to an
appropriate scale for the x-axis. This is the \code{identity} function
by default, because most often the logFC is plotted as is.}

\item{ytfrm}{A function that transforms the \code{yaxis} column to an
appropriate scale for the y-axis. This is the \code{-log10(yval)} function
by default, because this is how we most often plot the y-axis.}

\item{xlab, ylab}{x and y axis labels}

\item{highlight}{A vector of featureIds to highlight, or a GeneSetDb
that we can extract the featureIds from for this purpose.}

\item{horiz_line}{A (optionally named) number vecor (length 1) that indicates
where a line should be drawn across the volcano plot. This is usually done
to signify statistical significance. When the number is "named", this
indicates that you want to find an approximation of the values plotted
on y based on some transformation of the values that is the named column
of x (like "padj"). The default value \code{c(padj = 0.10)} indicates you
want to draw a line at approximately where the adjust pvalue of 0.10 is
on the y-axis, which is the \emph{nominal} pvalues.}

\item{xhex}{The raw \code{.xv} (not \code{xtfrm(.xv)}) value that acts
as a threshold such that values less than this will be hexbinned.}

\item{yhex}{the \code{.yvt} value threshold. Vaues less than this will
be hexbinned.}

\item{width, height}{the width and height of the output plotly plot}

\item{shiny_source}{the name of this element that is used in shiny callbacks.
Defaults to \code{"mggenes"}.}

\item{ggtheme}{a ggplot theme, like the thing returned from
\code{ggplot2::theme_bw()}, for instance.}

\item{...}{pass through arguments (not used)}
}
\value{
a ploty plot object
}
\description{
Convenience function to create volcano plots from results generated within
this package. This is mostly used by \code{{sparrow.shiny}}.
}
\examples{
mg <- exampleSparrowResult()
volcanoPlot(mg)
volcanoPlot(mg, xhex=1, yhex=0.05)
}
