% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameCollections.R
\name{renameCollections}
\alias{renameCollections}
\title{Rename the collections in a GeneSetDb}
\usage{
renameCollections(x, rename = NULL, ...)
}
\arguments{
\item{x}{A GeneSetDb object}

\item{rename}{a named character vector. \code{names(rename)} are the names of
the collection you want to rename, and their values are the new names.}

\item{...}{pass it along}
}
\value{
GeneSetDb \code{x} with renamed \code{geneSets(x)$collection} values.
}
\description{
This function remaps names of collections in the database from their current
names to ones specified by the user, folows the \code{dplyr::rename} convenction
where \code{names()} of the rename vector are the new names you want, and its
values are the old names it came from.
}
\examples{
gdb <- exampleGeneSetDb()
ngdb <- renameCollections(gdb, c("MSigDB C2" = "c2", "ImmuneSigDb" = "c7"))
all.equal(
  unname(geneSetURL(gdb, "c7", "GSE3982_BCELL_VS_TH2_DN")),
  unname(geneSetURL(ngdb, "ImmuneSigDb", "GSE3982_BCELL_VS_TH2_DN")))
}
