% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-kegg.R
\name{getKeggCollection}
\alias{getKeggCollection}
\alias{getKeggGeneSetDb}
\title{Retrieves the KEGG gene set collection via its REST API}
\usage{
getKeggCollection(species = "human", id.type = c("ensembl", "entrez"), ...)

getKeggGeneSetDb(species = "human", id.type = c("ensembl", "entrez"), ...)
}
\arguments{
\item{species}{\code{"human"}, \code{"mouse"} or any of the bioconductor or kegg-style
abbreviations.}

\item{id.type}{Gene identifiers are returned by the REST service as
entrez identifiers. Set this to \code{"ensembl"} to translate them internally
using \code{\link[=convertIdentifiers]{convertIdentifiers()}}. If \code{species}is not \code{"human"} or \code{"mouse"},
you need to provide an idxref table that works with \code{\link[=convertIdentifiers]{convertIdentifiers()}}.}

\item{...}{pass through arguments}
}
\value{
A BiocSet of the kegg stuffs
}
\description{
Uses \code{\link[limma:goana]{limma::getGeneKEGGLinks()}} and \code{\link[limma:goana]{limma::getKEGGPathwayNames()}}
internally.
}
\details{
Currently we just support the pathway database, and only entrez ids.

Note that \strong{it is your responsibility} to ensure that you can use the KEGG
database according to their licensing requirements.
}
\section{Functions}{
\itemize{
\item \code{getKeggGeneSetDb()}: method that returns a GeneSetDb

}}
\examples{
\donttest{
# connects to the internet and takes a while
mouse.entrez <- getKeggCollection("mouse", id.type = "entrez")
human.enrez <- getKeggCollection("human", id.type = "entrez")
}
}
