% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R
\name{conform}
\alias{conform}
\alias{unconform}
\alias{conform,GeneSetDb-method}
\alias{unconform,GeneSetDb-method}
\alias{is.conformed}
\title{(Re)-map geneset IDs to the rows in an expression object.}
\usage{
conform(x, ...)

unconform(x, ...)

\S4method{conform}{GeneSetDb}(
  x,
  target,
  unique.by = c("none", "mean", "var"),
  min.gs.size = 2L,
  max.gs.size = Inf,
  match.tolerance = 0.25,
  ...
)

\S4method{unconform}{GeneSetDb}(x, ...)

is.conformed(x, to)
}
\arguments{
\item{x}{The GeneSetDb}

\item{...}{moar args}

\item{target}{The expression object/matrix to conform to. This could also
just be a character vector of IDs.}

\item{unique.by}{If there are multiple rows that map to the identifiers used
in the genesets, this is a means to pick the single row for that ID}

\item{min.gs.size}{Ensure that the genesets that make their way to the
\code{GeneSetDb@table} are of a minimum size}

\item{max.gs.size}{Ensure that the genesets that make their way to the
\code{GeneSetDb@table} are smaller than this size}

\item{match.tolerance}{Numeric value between [0,1]. If the fraction of
\code{feature_id}s used in \code{x} that match \code{rownames(y)} is below
this number, a warning will be fired.}

\item{to}{the object to test conformation to}
}
\value{
A  \code{\link[=GeneSetDb]{GeneSetDb()}} that has been matched/conformed to an expression
object target \code{y}.
}
\description{
\code{conform}-ing, a \code{GeneSetDb} to a target expression
object is an important step required prior to perform any type of GSEA. This
function maps the featureIds used in the GeneSetDb to the elements of a
target expression object (ie. the rows of an expression matrix, or the
elements of a vector of gene-level statistics).

After \code{conform}-ation, each geneset in the \code{GeneSetDb} is flagged
as active (or inactive) given the number of its features that are
successfully mapped to \code{target} and the minimum and maximum number of
genes per geneset required as specified by the \code{min.gs.size} and
\code{max.gs.size} parameters, respectively.

Only genesets that are marked with \code{active = TRUE} will be used in any
downstream gene set operations.
}
\section{Functions}{
\itemize{
\item \code{is.conformed()}: Checks to see if GeneSetDb \code{x} is conformed to a target
object \code{to}

}}
\section{Related Functions}{

\itemize{
\item \code{\link[=unconform]{unconform()}}: Resets the conformation mapping.
\item \code{\link[=is.conformed]{is.conformed()}}: If \code{to} is missing, looks for evidence that \code{conform} has
been called (at all) on \code{x}. If \code{to} is provided, specifically checks that
\code{x} has been conformed to the target object \code{to}.
}
}

\examples{
es <- exampleExpressionSet()
gdb <- exampleGeneSetDb()
head(geneSets(gdb))
gdb <- conform(gdb, es)
## Note the updated values `active` flag, and n (the number of features
## mapped per gene set)
head(geneSets(gdb))
}
