% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotCellTypeWeight}
\alias{plotCellTypeWeight}
\title{Plot pixel proportions for a specific cell type}
\usage{
plotCellTypeWeight(
  rctd_spe,
  cell_type,
  assay_name = "weights",
  size = 10,
  stroke = 1,
  alpha = 1,
  low = "white",
  high = "red",
  title = NA
)
}
\arguments{
\item{rctd_spe}{\code{\link[SpatialExperiment]{SpatialExperiment}} object
containing RCTD results}

\item{cell_type}{character, name of cell type to plot}

\item{assay_name}{character, name of the assay to plot
(default: \code{"weights"})}

\item{size}{numeric, size of the points (default: 10)}

\item{stroke}{numeric, border width of the points (default: 1)}

\item{alpha}{numeric, point transparency between 0 and 1 (default: 1)}

\item{low}{color for the low end of the proportion color scale
(default: \code{"white"})}

\item{high}{color for the high end of the proportion color scale
(default: \code{"red"})}

\item{title}{character, plot title (default: \code{NA})}
}
\value{
\code{ggplot} object showing the proportion of a specified cell type
  at each pixel
}
\description{
Creates a visualization showing how the proportion of a specific cell type
varies across space, represented by point color intensity. Users should run
this function on the result of \code{\link{runRctd}}.
}
\details{
This function is adapted from \code{vizTopic} in the \code{STdeconvolve}
package.
}
\examples{
data(rctdSim)

# In practice, results_spe should contain the results of an RCTD run.
results_spe <- rctdSim$proportions_spe
plotCellTypeWeight(
    results_spe, "ct1", size = 5, title = "Cell Type Density (ct1)"
)

}
