% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform_effect_normalization.R
\name{chooseSigmaC}
\alias{chooseSigmaC}
\title{Estimates sigma_c by maximum likelihood}
\usage{
chooseSigmaC(RCTD)
}
\arguments{
\item{RCTD}{an \code{\linkS4class{RctdConfig}} object after running the
\code{\link{fitBulk}} function.}
}
\value{
Returns an \code{\linkS4class{RctdConfig}} with the estimated
  \code{sigma_c}.
}
\description{
Estimates sigma_c by maximum likelihood
}
\examples{
data(rctdSim)

# Spatial transcriptomics data
library(SpatialExperiment)
spatial_spe <- SpatialExperiment(
    assay = rctdSim$spatial_rna_counts,
    spatialCoords = rctdSim$spatial_rna_coords
)

# Reference data
library(SummarizedExperiment)
reference_se <- SummarizedExperiment(
    assays = list(counts = rctdSim$reference_counts),
    colData = rctdSim$reference_cell_types
)

# Create RCTD configuration
rctd_data <- createRctd(spatial_spe, reference_se)
rctd <- createRctdConfig(rctd_data)
rctd <- fitBulk(rctd)
rctd <- chooseSigmaC(rctd)
results <- fitPixels(rctd, rctd_mode = "doublet")

}
\keyword{internal}
