% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_stripes.R
\name{simulate_stripes}
\alias{simulate_stripes}
\title{simulate_stripes}
\usage{
simulate_stripes(
  bg_sample = bg1,
  n_stripe_type = 2,
  stripe_properties = list(S1 = list(number_of_stripes = 1, name_of_stripe_cell =
    "Others", width_of_stripe = 80, infiltration_types = c("Immune"),
    infiltration_proportions = c(0.08)), S2 = list(number_of_stripes = 1,
    name_of_stripe_cell = "Others", width_of_stripe = 80, infiltration_types =
    c("Immune"), infiltration_proportions = c(0.08))),
  plot_image = TRUE,
  plot_categories = NULL,
  plot_colours = NULL
)
}
\arguments{
\item{bg_sample}{(OPTIONAL) A data frame or \code{SpatialExperiment} class object
with locations of points representing background cells. Further cell types
will be simulated based on this background sample. The data.frame or the
\code{spatialCoords()} of the SPE object should have colnames including
"Cell.X.Positions" and "Cell.Y.Positions". By default use the internal
\code{\link{bg1}} background image.}

\item{n_stripe_type}{Number of stripe types. Should be the same as
\verb{length(stripe_properties}.}

\item{stripe_properties}{List of the properties of the stripes. See examples
for the format of the properties. Please refer to the examples for the
structure of \code{stripe_properties}.}

\item{plot_image}{Boolean. Whether the simulated image is plotted. Default is
TRUE.}

\item{plot_categories}{String Vector specifying the order of the cell
categories to be plotted. Default is NULL - the cell categories under the
"Cell.Type" column would be used for plotting.}

\item{plot_colours}{String Vector specifying the order of the colours that
correspond to the \code{plot_categories} arg. Default is NULL - the predefined
colour vector would be used for plotting.}
}
\value{
A data.frame of the simulated image
}
\description{
Based on an existing background image, simulate stripes of cells
representing vessels. The cell types and widths of the stripes can be
specified. The locations of the stripes are randomly simulated. Please
refer to the examples to check what properties of the stripes can be
specified. The default values for the arguments give an example of vessel
simulation which enable an automatic simulation of vessels without the
specification of any argument.
}
\examples{
stripe_properties <- list(
S1 = list(
  number_of_stripes = 1,
  name_of_stripe_cell = "Others",
  width_of_stripe = 80,
  infiltration_types = c("Immune"),
  infiltration_proportions = c(0.08)
), S2 = list(
  number_of_stripes = 1,
  name_of_stripe_cell = "Others",
  width_of_stripe = 80,
  infiltration_types = c("Immune"),
  infiltration_proportions = c(0.08)))
set.seed(610)
stripe_image <- simulate_stripes(bg_sample = bg1, n_stripe_type=2,
stripe_properties = stripe_properties, plot_image = TRUE)
}
\seealso{
\code{\link{simulate_background_cells}} for all cell simulation,
\code{\link{simulate_mixing}} for mixed background simulation,
\code{\link{simulate_clusters}} for cluster simulation, and
\code{\link{simulate_immune_rings}}/\code{\link{simulate_double_rings}} for
immune ring simulation

Other simulate pattern functions: 
\code{\link{simulate_background_cells}()},
\code{\link{simulate_clusters}()},
\code{\link{simulate_double_rings}()},
\code{\link{simulate_immune_rings}()},
\code{\link{simulate_mixing}()}
}
\concept{simulate pattern functions}
