% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeMetricsFromSF.R
\name{stCalculateCurvature}
\alias{stCalculateCurvature}
\title{Calculate curvature of sf object}
\usage{
stCalculateCurvature(sfPoly, smoothness = 5)
}
\arguments{
\item{sfPoly}{\code{POLYGON } of class \code{sf}}

\item{smoothness}{list; curvature measures}
}
\value{
list; list of curvatures values
}
\description{
Calculate curvature of sf object
}
\examples{
matrixR <- matrix(c(
    0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 1, 1, 0, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0
), nrow = 9, byrow = TRUE)
polyR <- binaryImageToSF(matrixR, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
stCalculateCurvature(polyR)
}
\references{
https://stackoverflow.com/questions/62250151/calculate-curvature-of-a-closed-object-in-r
}
