% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructShapePPP.R
\name{estimateReconstructionParametersSPE}
\alias{estimateReconstructionParametersSPE}
\title{Estimate reconstruction parameters from a set of images}
\usage{
estimateReconstructionParametersSPE(
  spe,
  marks,
  imageCol = NULL,
  markSelect = NULL,
  nImages = NULL,
  fun = "bw.diggle",
  dim = 500,
  nCores = 1,
  plotHist = TRUE
)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{marks}{character; name of column in \code{colData} that will correspond to
the \code{ppp} marks}

\item{imageCol}{character; name of a column in \code{colData} that corresponds
to the image}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{nImages}{integer; number of images for the estimation. Will be randomly
sampled}

\item{fun}{character; function to estimate the kernel density. Default
bw.diggle.}

\item{dim}{numeric; x dimension of the final reconstruction.
A lower resolution speed up computation but lead to less exact reconstruction.
Default = 500}

\item{nCores}{numeric; number of cores for parallel processing using \code{mclapply}.
Default = 1}

\item{plotHist}{logical; if histogram of estimated densities and thresholds
should be plotted (only if \code{imageCol} is not NULL). Default = TRUE}
}
\value{
tibble; tibble with estimated intensities and thresholds
}
\description{
Estimate reconstruction parameters from a set of images
}
\examples{
data("sostaSPE")
estimateReconstructionParametersSPE(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    markSelect = "A", plotHist = TRUE
)
}
