% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellLevelMetrics.R
\name{cellTypeProportions}
\alias{cellTypeProportions}
\title{Calculate the proportion of each cell type within spatial structures}
\usage{
cellTypeProportions(spe, structColumn, cellTypeColumn, nCores = 1)
}
\arguments{
\item{spe}{SpatialExperiment object}

\item{structColumn}{character; name of the \code{colData} column specifying the structure assignments}

\item{cellTypeColumn}{character; name of the \code{colData} column specifying cell types}

\item{nCores}{integer; The number of cores to use for parallel processing (default is 1).}
}
\value{
A data frame where rows correspond to unique structures and columns correspond to cell types,
containing the proportion of each cell type within each structure.
}
\description{
Calculate the proportion of each cell type within spatial structures
}
\examples{
library("SpatialExperiment")
data("sostaSPE")
allStructs <- reconstructShapeDensitySPE(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    markSelect = "A", bndw = 3.5, thres = 0.045
)
# The function `assingCellsToStructures` needs colnames so we create them here
colnames(sostaSPE) <- paste0("cell_", c(1:dim(sostaSPE)[2]))
# Assign the structure assignment in the order of the columns in the `SpatialExperiment` object
colData(sostaSPE)$structAssign <- assingCellsToStructures(
    spe = sostaSPE, allStructs = allStructs, imageCol = "imageName"
)[colnames(sostaSPE)]
cellTypeProportions(sostaSPE, "structAssign", "cellType")
}
