% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SPE2ppp}
\alias{SPE2ppp}
\title{Function to convert spatial coordinates of a \code{SpatialExperiment} object to a \code{ppp} object}
\usage{
SPE2ppp(spe, marks = NULL, imageCol = NULL, imageId = NULL)
}
\arguments{
\item{spe}{SpatialExperiment; a object of class \code{SpatialExperiment}}

\item{marks}{character; name of column in \code{colData} that will correspond to
the \code{ppp} marks}

\item{imageCol}{character; name of a column in \code{colData} that corresponds to
the image}

\item{imageId}{character; image id, must be present in imageCol}
}
\value{
ppp; object of type \code{ppp}
}
\description{
Function to convert spatial coordinates of a \code{SpatialExperiment} object to a \code{ppp} object
}
\examples{
data(sostaSPE)
SPE2ppp(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    imageId = "image1"
)
}
