% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{pwmToCoverage}
\alias{makeMotifScoreRle}
\alias{pwmToCoverage}
\title{PWM hits and motif scores as an RLElist}
\usage{
pwmToCoverage(pwm, genome, min = "70\%", removeRand = FALSE,
  chrsOfInterest = NULL)

makeMotifScoreRle(pwm, regions, genome, extend, removeRand = FALSE,
  strandScore = "mean", atCentre = FALSE)
}
\arguments{
\item{pwm}{A PWM matrix object.}

\item{genome}{A BSgenome object}

\item{min}{pwm score (as percentage of maximum score) cutoff}

\item{removeRand}{Remove contigs with rand string}

\item{chrsOfInterest}{Chromosomes to use}

\item{regions}{GRanges object to include in pwm rlelist}

\item{extend}{bps to extend regions by}

\item{strandScore}{Method for averaging strand. Options are max, mean, sum, bothstrands}

\item{atCentre}{TRUE/FALSE. TRUE assigns score onto 1bp position at centre of motif.
FALSE assigns every basepair the sum of scores of all overlapping motifs.}
}
\value{
A RLElist of motif density per base pair to be used as input to main soggi function.
}
\description{
Creates rlelist of pwm hits.

Motif score as an RLElist
}
\examples{
data(pwmCov)
data(singleGRange)
}
\author{
Thomas Carroll
}

