% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{plotRegion}
\alias{plotRegion}
\alias{plotRegion,ChIPprofile-method}
\alias{plotRegion.ChIPprofile}
\title{Plot regions}
\usage{
\S4method{plotRegion}{ChIPprofile}(object,
gts,sampleData,groupData,summariseBy,
colourBy,lineBy,groupBy,
plotregion,outliers,freeScale)

\S4method{plotRegion}{ChIPprofile}(object = "ChIPprofile", gts = NULL,
  sampleData = NULL, groupData = NULL, summariseBy = NULL,
  colourBy = NULL, lineBy = NULL, groupBy = NULL, plotregion = "full",
  outliers = NULL, freeScale = FALSE)
}
\arguments{
\item{object}{A ChIPprofile object}

\item{gts}{A list of character vectors or GRangesList}

\item{plotregion}{region to plot. For combined plots with style "region", may be "start" or "end" to show full resolution of plot of edges.}

\item{groupData}{Dataframe of metadata for groups}

\item{sampleData}{Dataframe of metadata for sample}

\item{summariseBy}{Column names from GRanges elementmetadata. Formula or character vector of column names to use
to collapse genomic ranges to summarised profiles.
summariseBy can not be used injustion with groups specified by gts argument.}

\item{colourBy}{Character vector or formula of either column names from colData(object) containing
sample metadata or character vector "group" to colour by groups in gts}

\item{lineBy}{Character vector or formula of either column names from colData(object) containing
sample metadata or character vector "group" to set line type by groups in gts}

\item{groupBy}{Character vector or formula of either column names from colData(object) containing
sample metadata or character "group" to colour by groups in gts}

\item{outliers}{A numeric vector of length 1 containing proportion from limits to windsorise.]}

\item{freeScale}{TRUE or FALSE to set whether ggplot 2 facets have their own scales.
Useful for comparing multiple samples of differing depths without normalisation. Default is FALSE.}
}
\value{
A gg object from ggplot2
}
\description{
A function to plot regions
}
\examples{
data(chipExampleBig)
plotRegion(chipExampleBig[[2]])
}
\author{
Thomas Carroll
}

