% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{normalise}
\alias{normalise}
\alias{normalise,ChIPprofile,character,numeric-method}
\alias{normalise,ChIPprofile-method}
\alias{normalise.ChIPprofile}
\title{Normalise ChIPprofiles}
\usage{
\S4method{normalise}{ChIPprofile}(object)

\S4method{normalise}{ChIPprofile,character,numeric}(object = "ChIPprofile",
  method = "rpm", normFactors = NULL)
}
\arguments{
\item{object}{A ChIPprofile object}

\item{method}{A character vector specifying normalisation method.
Currently "rpm" for normalising signal for BAM to total reads,
"quantile" to quantile normalise across samples,
"signalInRegion" to normalise to proportion of signal within intervals,
"normaliseSample" to normalise across samples and "normaliseRegions" to apply a normalisation across intervals.}

\item{normFactors}{A numeric vector used to scale columns or rows.}
}
\value{
A ChIPprofile object
}
\description{
Various normalisation methods for ChIPprofile objects
}
\examples{
data(chipExampleBig)
normalise(chipExampleBig,method="quantile",normFactors=1)
}
\author{
Thomas Carroll
}

