% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLMMs.R, R/getResults.R
\name{fitLMMs}
\alias{fitLMMs}
\alias{fitLMMsSingle}
\alias{getResults}
\title{Fit linear (mixed) models for all probabilistic indices (PIs) and all genes}
\usage{
fitLMMs(
  obj,
  pis = obj$pis,
  fixedVars = NULL,
  randomVars = NULL,
  verbose = TRUE,
  returnModels = FALSE,
  Formula = NULL,
  randomNested = TRUE,
  features = getEstFeatures(obj),
  ...
)

fitLMMsSingle(
  obj,
  pi,
  fixedVars,
  randomVars,
  verbose,
  returnModels,
  Formula,
  randomNested,
  features
)

getResults(obj, pi, parameter)
}
\arguments{
\item{obj}{The result object}

\item{pis}{Optional, the pis required. Defaults to all pis in the object}

\item{fixedVars}{Names of fixed effects}

\item{randomVars}{Names of random variables}

\item{verbose}{A boolean, should the formula be printed?}

\item{returnModels}{a boolean: should the full models be returned?
Otherwise only summary statistics are returned}

\item{Formula}{A formula; if not supplied it will be constructed
from the fixed and random variables}

\item{randomNested}{A boolean, indicating if random effects are nested within
point patterns. See details.}

\item{features}{The features for which to fit linear mixed models.
Defaults to all features in the object}

\item{...}{Passed onto fitLMMsSingle}

\item{pi}{The desired PI}

\item{parameter}{The desired parameter}
}
\value{
For fitLMMs(), a list of fitted objects

For fitLMMsSingle(), a list of test results, if requested also the linear models are returned

For getResults(), the matrix with results, with p-values in ascending order
\item{Estimate}{The estimated PI}
\item{se}{The corresponding standard error}
\item{pVal}{The p-value}
\item{pAdj}{The Benjamini-Hochberg adjusted p-value}
}
\description{
The PI is used as outcome variable in a linear (mixed) model,
with design variables as regressors. Separate models are fitted for every combination of gene
and PI. fitLMMsSingle() is the workhorse function for a single point pattern,
fitSingleLmmModel() for a single feature in a single point pattern.

getResults() extracts effect size estimates, standard errors and adjusted p-values for a certain parameter
from a linear model.
}
\details{
Genes or gene pairs with insufficient observations will be silently
omitted. When randomVars is provided as a vector, independent random
intercepts are fitted for them by default. Providing them separated by '\' or
':' as in the lmer formulas is also allowed to reflect nesting structure, 
but the safest is to construct the formula yourself and pass it onto fitLMMs.

It is by default assumed that random effects are nested within the point
 patterns. This means for instance that cells with the same name but from
 different point patterns are assigned to different random effects. Set
'randomNested' to FALSE to override this behaviour.
}
\examples{
example(addWeightFunction, "smoppix")
lmmModels <- fitLMMs(yangObj, fixedVars = "day", randomVars = "root")
res <- getResults(lmmModels, "nn", "Intercept") #Extract the results
head(res)
}
\seealso{
\link{buildDataFrame}
}
