% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{iae_igm}
\alias{iae_igm}
\title{labeled inverse average expression: IGM}
\usage{
iae_igm(expr, features = NULL, label, lambda = 7, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{label}{vector, group label of each cell}

\item{lambda}{numeric, hyperparameter for IGM}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a vector of inverse gravity moment score for each feature
}
\description{
labeled inverse average expression: IGM
}
\details{
\deqn{\mathbf{IGM_i} = log(1+\lambda\frac{max(mean(N_{i,j\in D})_{k})}{\sum_{k}^{K}(mean(N_{i,j\in D})_{k}*r_{k})+e^{-8}})}
where \eqn{\lambda} is the hyper parameter, \eqn{N_{i,j\in D}} is the counts
of feature \eqn{i} in cell \eqn{j} within class \eqn{D}, and \eqn{r_k} is the
rank of \eqn{mean(N_{i,j\in D})}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::iae_igm(data, label = sample(c("A", "B"), 10, replace = TRUE))
}
