% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingPseudotime}
\alias{slingPseudotime}
\alias{slingCurveWeights}
\alias{slingAvgPseudotime}
\alias{slingPseudotime,PseudotimeOrdering-method}
\alias{slingPseudotime,SingleCellExperiment-method}
\alias{slingPseudotime,SlingshotDataSet-method}
\alias{slingCurveWeights,PseudotimeOrdering-method}
\alias{slingCurveWeights,SingleCellExperiment-method}
\alias{slingCurveWeights,SlingshotDataSet-method}
\alias{slingAvgPseudotime,ANY-method}
\title{Get Slingshot pseudotime values}
\usage{
slingPseudotime(x, ...)

slingCurveWeights(x, ...)

slingAvgPseudotime(x, ...)

\S4method{slingPseudotime}{PseudotimeOrdering}(x, na = TRUE)

\S4method{slingPseudotime}{SingleCellExperiment}(x, na = TRUE)

\S4method{slingPseudotime}{SlingshotDataSet}(x, na = TRUE)

\S4method{slingCurveWeights}{PseudotimeOrdering}(x, as.probs = FALSE)

\S4method{slingCurveWeights}{SingleCellExperiment}(x, as.probs = FALSE)

\S4method{slingCurveWeights}{SlingshotDataSet}(x, as.probs = FALSE)

\S4method{slingAvgPseudotime}{ANY}(x)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}

\item{...}{additional parameters to be passed to object-specific methods.}

\item{na}{logical. If \code{TRUE} (default), cells that are not assigned to a
lineage will have a pseudotime value of \code{NA}. Otherwise, their
arclength along each curve will be returned.}

\item{as.probs}{logical. If \code{FALSE} (default), output will be the
weights used to construct the curves, appropriate for downstream analysis
of individual lineages (ie. a cell shared between two lineages can have two
weights of \code{1}). If \code{TRUE}, output will be scaled to represent
probabilistic assignment of cells to lineages (ie. a cell shared between
two lineages will have two weights of \code{0.5}).}
}
\value{
\code{slingPseudotime}: an \code{n} by \code{L} matrix representing
  each cell's pseudotime along each lineage.

\code{slingCurveWeights}: an \code{n} by \code{L} matrix of cell
  weights along each lineage.

\code{slingAvgPseudotime}: a length \code{n} vector of average cell
  pseudotimes, where the average is a weighted average across lineages,
  weighted by the assignment weights.
}
\description{
Extract the matrix of pseudotime values or cells' weights along
  each lineage.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingPseudotime(pto)
slingCurveWeights(pto)
slingAvgPseudotime(pto)
}
