% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingLineages}
\alias{slingLineages}
\alias{slingLineages,PseudotimeOrdering-method}
\alias{slingLineages,SingleCellExperiment-method}
\alias{slingLineages,SlingshotDataSet-method}
\title{Extract the Slingshot lineages}
\usage{
slingLineages(x)

\S4method{slingLineages}{PseudotimeOrdering}(x)

\S4method{slingLineages}{SingleCellExperiment}(x)

\S4method{slingLineages}{SlingshotDataSet}(x)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}
}
\value{
A list of lineages, represented by ordered sets of clusters.
}
\description{
Extract lineages (represented by ordered sets of clusters)
  identified by \code{\link{slingshot}}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingLineages(pto)
}
