% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\name{slingCurves}
\alias{slingCurves}
\alias{slingCurves,PseudotimeOrdering-method}
\alias{slingCurves,SingleCellExperiment-method}
\alias{slingCurves,SlingshotDataSet-method}
\title{Extract simultaneous principal curves}
\usage{
slingCurves(x, ...)

\S4method{slingCurves}{PseudotimeOrdering}(x, as.df = FALSE)

\S4method{slingCurves}{SingleCellExperiment}(x, ...)

\S4method{slingCurves}{SlingshotDataSet}(x, as.df = FALSE)
}
\arguments{
\item{x}{an object containing \code{\link{slingshot}} output.}

\item{...}{additional parameters to be passed to object-specific methods.}

\item{as.df}{logical, whether to format the output as a \code{data.frame},
suitable for plotting with \code{ggplot}.}
}
\value{
A list of smooth lineage curves, each of which is a
  \code{\link[princurve]{principal_curve}} object.
}
\description{
Extract the simultaneous principal curves from an object
  containing \code{\link{slingshot}} output.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
slingCurves(pto)
}
