% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict,PseudotimeOrdering-method}
\alias{predict,PseudotimeOrdering-method}
\alias{predict,SlingshotDataSet-method}
\title{Predict from a Slingshot model}
\usage{
\S4method{predict}{PseudotimeOrdering}(object, newdata = NULL)

\S4method{predict}{SlingshotDataSet}(object, newdata = NULL)
}
\arguments{
\item{object}{a \code{\link[TrajectoryUtils]{PseudotimeOrdering}} or
\code{\link{SlingshotDataSet}} containing simultaneous principal curves to
use for prediction.}

\item{newdata}{a matrix or data frame of new points in the same
reduced-dimensional space as the original input to \code{slingshot} (or
\code{getLineages}).}
}
\value{
An object of the same type as \code{object}, based on the input
  \code{newdata}. New cells are treated as "unclustered", but other metadata
  is preserved. The \code{curves} slot represents the projections of each new
  cell onto the existing curves. As with standard \code{slingshot} output,
  the lineage-specific pseudotimes and assignment weights can be accessed via
  the functions \code{\link{slingPseudotime}} and
  \code{\link{slingCurveWeights}}.
}
\description{
Map new observations onto simultaneous principal curves fitted
  by \code{slingshot}.
}
\details{
This function is a method for the generic function \code{predict}
  with inputs being either a \code{PseudotimeOrdering} or
  \code{SlingshotDataSet}. If no \code{newdata} argument is provided, it will
  return the original results, given by \code{object}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')

x <- cbind(runif(100, min = -5, max = 10), runif(100, min = -4, max = 4))
predict(pto, x)

}
\seealso{
\code{\link{slingshot}}
}
