% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/conversion.R
\name{as.SlingshotDataSet}
\alias{as.SlingshotDataSet}
\alias{as.SlingshotDataSet,PseudotimeOrdering-method}
\alias{as.SlingshotDataSet,SingleCellExperiment-method}
\alias{as.SlingshotDataSet,SlingshotDataSet-method}
\title{Conversion to SlingshotDataSet}
\usage{
as.SlingshotDataSet(x, ...)

\S4method{as.SlingshotDataSet}{PseudotimeOrdering}(x)

\S4method{as.SlingshotDataSet}{SingleCellExperiment}(x)

\S4method{as.SlingshotDataSet}{SlingshotDataSet}(x)
}
\arguments{
\item{x}{an object containing \code{slingshot} output.}

\item{...}{additional arguments to pass to object-specific methods.}
}
\value{
A \code{SlingshotDataSet} object containing the \code{slingshot}
  results from the original object, \code{x}.
}
\description{
This function converts objects that contain \code{slingshot}
  results into a \code{SlingshotDataSet}.
}
\examples{
data("slingshotExample")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
pto <- slingshot(rd, cl, start.clus = '1')
as.SlingshotDataSet(pto)

}
\seealso{
\code{\link[TrajectoryUtils]{PseudotimeOrdering}}
}
