% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllHelperFunctions.R
\docType{class}
\name{SlingshotDataSet-class}
\alias{SlingshotDataSet-class}
\alias{show,SlingshotDataSet-method}
\alias{reducedDim,SlingshotDataSet,ANY-method}
\alias{reducedDims,SlingshotDataSet-method}
\title{Class \code{SlingshotDataSet}}
\usage{
\S4method{show}{SlingshotDataSet}(object)

\S4method{reducedDim}{SlingshotDataSet,ANY}(x)

\S4method{reducedDims}{SlingshotDataSet}(x)
}
\arguments{
\item{object}{a \code{SlingshotDataSet} object.}

\item{x}{a \code{SlingshotDataSet} object.}
}
\value{
The accessor functions \code{reducedDim}, \code{clusterLabels}, 
  \code{lineages}, \code{adjacency}, \code{curves},
  and \code{slingParams} return the corresponding elements of a 
  \code{SlingshotDataSet}. The functions \code{slingPseudotime} and 
  \code{slingCurveWeights} extract useful output elements of a 
  \code{SlingshotDataSet}, provided that curves have already been fit with 
  either \code{slingshot} or \code{getCurves}.
}
\description{
This was the original class for storing \code{slingshot}
  results, but we now generally reommend using the
  \code{\link{PseudotimeOrdering}} class, instead. Most \code{slingshot}
  functions will still work with \code{SlingshotDataSet} objects, but will
  return \code{PseudotimeOrdering} objects, by default. To update old
  \code{SlingshotDataSet} objects, we have provided the
  \code{\link{as.PseudotimeOrdering}} conversion function. The only functions
  that require \code{SlingshotDataSet} objects are the plotting functions.

The \code{SlingshotDataSet} class holds data relevant for 
  performing lineage inference with the \code{slingshot} package, primarily a
  reduced dimensional representation of the data and a set of cluster labels.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: a short summary of a \code{SlingshotDataSet}
object.

\item \code{reducedDim}: returns the matrix representing the reduced
dimensional dataset.
}}

\section{Slots}{

\describe{
\item{\code{reducedDim}}{matrix. An \code{n} by \code{p} numeric matrix or data frame
giving the coordinates of the cells in a reduced dimensionality space.}

\item{\code{clusterLabels}}{matrix or character. An \code{n} by \code{K} matrix of 
weights indicating each cell's cluster assignment or a character vector of
cluster assignments, which will be converted into a binary matrix.}

\item{\code{lineages}}{list. A list with each element a character vector of cluster 
names representing a lineage as an ordered set of clusters.}

\item{\code{adjacency}}{matrix. A binary matrix describing the adjacency 
between clusters induced by the minimum spanning tree.}

\item{\code{curves}}{list. A list of \code{\link[princurve]{principal_curve}} objects
produced by \code{\link{getCurves}}.}

\item{\code{slingParams}}{list. Additional parameters used by Slingshot. These may 
specify how the minimum spanning tree on clusters was constructed: 
\itemize{ 
\item{\code{start.clus}}{ character. The label of the root cluster, or a
vector of cluster labels giving the root clusters of each disjoint
component of the graph.}
\item{\code{end.clus}}{ character. Vector of cluster labels indicating 
terminal clusters.}
\item{\code{start.given}}{ logical. A logical value 
indicating whether the initial state was pre-specified.} 
\item{\code{end.given}}{ logical. A vector of logical values indicating 
whether each terminal state was pre-specified} 
\item{\code{omega}}{ numeric or logical. Granularity parameter determining
the maximum edge length for building the MST. See
\code{\link{getLineages}}.}
\item{\code{omega_scale}}{ numeric. Scaling factor used for setting maximum
edge length when \code{omega = TRUE}. See \code{\link{getLineages}}.} }
They may also specify how simultaneous principal curves were constructed
(for a complete listing, see \code{\link{getCurves}}:
\itemize{ 
\item{\code{shrink}}{ logical or numeric between 0 and 1. Determines
whether and how much to shrink branching lineages toward their shared
average curve.}
\item{\code{extend}}{ character. Specifies the method for handling 
root and leaf clusters of lineages when constructing the initial, 
piece-wise linear curve. Accepted values are 'y' (default), 'n', and 'pc1'.
See \code{\link{getCurves}} for details.} 
\item{\code{reweight}}{ logical. 
Indicates whether to allow cells shared
between lineages to be reweighted during curve-fitting. If \code{TRUE},
cells shared between lineages will be iteratively reweighted based on the
quantiles of their projection distances to each curve.} 
\item{\code{reassign}}{ logical. 
Indicates whether to reassign cells to lineages at each
iteration. If \code{TRUE}, cells will be added to a lineage when their
projection distance to the curve is less than the median distance for all
cells currently assigned to the lineage. Additionally, shared cells will be
removed from a lineage if their projection distance to the curve is above
the 90th percentile and their weight along the curve is less than
\code{0.1}.} 
\item{\code{shrink.method}}{ character. 
Denotes how to determine the amount of shrinkage for a branching lineage. 
Accepted values are the same as for \code{kernel} in  the \code{density} 
function (default is \code{"cosine"}), as well as \code{"tricube"} and 
\code{"density"}. See \code{\link{getCurves}} for details.}
\item{approx_points}{ numeric. Number of points to use in estimating
curves. See \code{\link{getCurves}} for details.} \item{allow.breaks}{
logical. Whether to allow curves that diverge very early on in a trajectory
to have different starting points.}
\item{Other parameters specified by 
\code{\link[princurve]{principal_curve}}}. }}
}}

\seealso{
\code{\link{PseudotimeOrdering}}
}
