% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlalomModel-methods.R
\docType{methods}
\name{trainSlalom}
\alias{trainSlalom}
\alias{train}
\alias{train,Rcpp_SlalomModel-method}
\title{Train a SlalomModel object}
\usage{
trainSlalom(object, nIterations = 5000, minIterations = 700,
  tolerance = 1e-08, forceIterations = FALSE, shuffle = TRUE,
  pretrain = TRUE, verbose = TRUE, seed = NULL, drop_factors = TRUE)
}
\arguments{
\item{object}{a \code{Rcpp_SlalomModel} object}

\item{nIterations}{integer(1) maximum number of iterations to use in training
the model (default: 5000)}

\item{minIterations}{integer(1) minimum number of iterations to perform.}

\item{tolerance}{numeric(1) tolerance to allow between iterations
(default 1e-08)}

\item{forceIterations}{logical(1) should the model be forced to update
\code{nIteration} times?}

\item{shuffle}{logical(1) should the order in which factors are updated be
shuffled between iterations? Shuffling generally helps speed up convergence
so is recommended and defaults is \code{TRUE}}

\item{pretrain}{logical(1), should the model be "pre-trained" to achieve
faster convergence and obtain an initial update order? Recommended; default
is \code{TRUE}}

\item{verbose}{logical(1), should messages be printed about what the function
is doing? Default is \code{TRUE}.}

\item{seed}{integer(1) value supplying a random seed to make results
reproducible (default is \code{NULL})}

\item{drop_factors}{logical(1), should factors be dropped from the model if
the model determines them not to be relevant? Default is \code{TRUE}.}
}
\value{
an `Rcpp_SlalomModel` object
}
\description{
Train a SlalomModel to infer model parameters.
}
\details{
Train the model using variational Bayes methods to infer parameters.
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- trainSlalom(model, nIterations = 10)
}
\author{
Davis McCarthy
}
