\name{getBarcodes}
\alias{getBarcodes}

\title{
Get barcodes from idat file names
}
\description{
A convenience function for retrieving simple barcodes from idat file names.
}
\usage{
getBarcodes(path = getwd(), recurse = FALSE)
}

\arguments{
  \item{path}{
The path or a character vector to the directory or directories in which to find the idat files.
}
  \item{recurse}{
  logical; should the function check subdirectories to derive barcodes from any found idat files. The default is \code{FALSE}.
}
}
\details{
Barcodes will be generated by all found idats in path(s). The default path is the current working directory.
}
\value{
A character vector of barcodes.
}

\author{
Ryan Putney \email{ryanputney@gmail.com}
}

\seealso{
\code{\link{getMethyLumiSet}}
}
\examples{

if(require(minfiData)){
  path <- system.file("extdata/5723646052", package="minfiData")
  barcodes <- getBarcodes(path = path)
}
}

\keyword{utilities}

