% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitesMinEntropy.R
\name{sitesMinEntropy}
\alias{sitesMinEntropy}
\alias{sitesMinEntropy.lineagePath}
\title{Fixation sites prediction}
\usage{
sitesMinEntropy(x, ...)

\method{sitesMinEntropy}{lineagePath}(
  x,
  minEffectiveSize = NULL,
  searchDepth = 1,
  method = c("compare", "insert", "delete"),
  ...
)
}
\arguments{
\item{x}{A \code{lineagePath} object returned from \code{\link{lineagePath}}
function.}

\item{...}{further arguments passed to or from other methods.}

\item{minEffectiveSize}{The minimum number of tips in a group.}

\item{searchDepth}{The function uses heuristic search but the termination of
the search cannot be intrinsically decided. \code{searchDepth} is needed to
tell the search when to stop.}

\item{method}{The strategy for predicting the fixation. The basic approach is
entropy minimization and can be achieved by adding or removing fixation
point, or by comparing the two.}
}
\value{
A \code{sitesMinEntropy} object.
}
\description{
After finding the \code{\link{lineagePath}} of a phylogenetic
  tree, \code{sitesMinEntropy} perform entropy minimization on every site of
  the sequence to group the tips according to amino acid/nucleotide.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
sitesMinEntropy(lineagePath(tree))
}
