% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelSites.R
\name{parallelSites}
\alias{parallelSites}
\alias{parallelSites.lineagePath}
\alias{parallelSites.sitesMinEntropy}
\alias{parallelSites.paraFixSites}
\title{Mutation across multiple phylogenetic lineages}
\usage{
parallelSites(x, ...)

\method{parallelSites}{lineagePath}(
  x,
  minSNP = NULL,
  mutMode = c("all", "exact", "pre", "post"),
  ...
)

\method{parallelSites}{sitesMinEntropy}(
  x,
  minSNP = NULL,
  mutMode = c("all", "exact", "pre", "post"),
  ...
)

\method{parallelSites}{paraFixSites}(x, ...)
}
\arguments{
\item{x}{A \code{\link{lineagePath}} or a \code{\link{sitesMinEntropy}}
object.}

\item{...}{The arguments in \code{\link{sitesMinEntropy}}.}

\item{minSNP}{The minimum number of mutations to be qualified as parallel on
at least two lineages. The default is 1.}

\item{mutMode}{The strategy for finding parallel site. The default \code{all}
is to consider any mutation regardless of the amino acid/nucleotide before
and after mutation; Or \code{exact} to force mutation to be the same; Or
\code{pre}/\code{post} to select the site having amino acid/nucleotide
before/after mutation.}
}
\value{
A \code{parallelSites} object
}
\description{
A site may have mutated on parallel lineages. Mutation can occur
  on the same site across the phylogenetic lineages solved by
  \code{\link{lineagePath}}. The site will be considered mutated in parallel
  if the mutation occurs on the non-overlap part of more than two lineages.
  The amino acid/nucleotide before and after the mutation can be allowed
  different on different lineages or only the exact same mutations are
  considered.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
paths <- lineagePath(tree)
x <- sitesMinEntropy(paths)
parallelSites(x)
}
