% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixationPath.R
\name{fixationPath}
\alias{fixationPath}
\alias{fixationPath.sitesMinEntropy}
\alias{fixationPath.fixationSites}
\title{Accumulation of fixed mutation as a tree}
\usage{
fixationPath(x, ...)

\method{fixationPath}{sitesMinEntropy}(x, minEffectiveSize = NULL, ...)

\method{fixationPath}{fixationSites}(x, minEffectiveSize = NULL, ...)
}
\arguments{
\item{x}{The return from \code{\link{fixationSites}} function.}

\item{...}{Further arguments passed to or from other methods.}

\item{minEffectiveSize}{The minimum size for a tip cluster.}
}
\value{
An \code{fixationPath} object
}
\description{
The tips are clustered according to the fixation sites. The
  transition of fixation sites will be plotted as a phylogenetic tree. The
  length of each branch represents the number of fixation mutation between
  two clusters. The name of the tree tips indicate the number of sequences in
  the cluster.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
paths <- lineagePath(tree)
mutations <- fixationSites(paths)
fixationPath(mutations)
}
