% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRankDensityGeneric.R
\name{plotRankDensity}
\alias{plotRankDensity}
\alias{plotRankDensity,ANY,vector,missing-method}
\alias{plotRankDensity,ANY,GeneSet,missing-method}
\alias{plotRankDensity,ANY,vector,vector-method}
\alias{plotRankDensity,ANY,GeneSet,GeneSet-method}
\title{Plot the densities of ranks for one sample}
\usage{
plotRankDensity(
  rankData,
  upSet,
  downSet = NULL,
  isInteractive = FALSE,
  textSize = 1.5
)

\S4method{plotRankDensity}{ANY,vector,missing}(
  rankData,
  upSet,
  downSet = NULL,
  isInteractive = FALSE,
  textSize = 1.5
)

\S4method{plotRankDensity}{ANY,GeneSet,missing}(
  rankData,
  upSet,
  downSet = NULL,
  isInteractive = FALSE,
  textSize = 1.5
)

\S4method{plotRankDensity}{ANY,vector,vector}(
  rankData,
  upSet,
  downSet = NULL,
  isInteractive = FALSE,
  textSize = 1.5
)

\S4method{plotRankDensity}{ANY,GeneSet,GeneSet}(
  rankData,
  upSet,
  downSet = NULL,
  isInteractive = FALSE,
  textSize = 1.5
)
}
\arguments{
\item{rankData}{one column of the ranked gene expression matrix obtained from
the \code{\link[=rankGenes]{rankGenes()}} function, use \code{drop = FALSE} when subsetting the ranked
gene expression matrix, see examples.}

\item{upSet}{GeneSet object or a vector of gene Ids, up-regulated gene set}

\item{downSet}{GeneSet object or a vector of gene Ids, down-regulated gene
set}

\item{isInteractive}{Boolean, determine whether the returned plot is
interactive}

\item{textSize}{numberic, set the size of text on the plot}
}
\value{
A ggplot object (or a plotly object) with a rank density plot
overlayed with a barcode plot
}
\description{
This function takes a single-column data frame, which is a
single-column subset of the ranked matrix data generated using
\code{\link[=rankGenes]{rankGenes()}} function, and the gene sets of interest as inputs. It plots
the density of ranks for genes in the gene set and overlays a barcode plot
of these ranks. Ranks are normalized by dividing them by the maximum rank.
Densities are estimated using KDE.
}
\examples{
ranked <- rankGenes(toy_expr_se)
plotRankDensity(ranked[,2,drop = FALSE], upSet = toy_gs_up)

}
