% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyFindMarkers}
\alias{runScanpyFindMarkers}
\title{runScanpyFindMarkers}
\usage{
runScanpyFindMarkers(
  inSCE,
  nGenes = NULL,
  useAssay = "scanpyNormData",
  colDataName,
  group1 = "all",
  group2 = "rest",
  test = c("wilcoxon", "t-test", "t-test_overestim_var", "logreg"),
  corr_method = c("benjamini-hochberg", "bonferroni")
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{nGenes}{The number of genes that appear in the returned tables. 
Defaults to all genes.}

\item{useAssay}{Specify the name of the assay to use for computation
of marker genes. It is recommended to use log normalized assay.}

\item{colDataName}{colData to use as the key of the observations grouping to 
consider.}

\item{group1}{Name of group1. Subset of groups, to which comparison shall be 
restricted, or 'all' (default), for all groups.}

\item{group2}{Name of group2. If 'rest', compare each group to the union of 
the rest of the group. If a group identifier, compare with respect to this 
group. Default is 'rest'}

\item{test}{Test to use for DE. Default \code{"t-test"}.}

\item{corr_method}{p-value correction method. Used only for 't-test', 
't-test_overestim_var', and 'wilcoxon'.}
}
\value{
A \code{SingleCellExperiment} object that contains marker genes
populated in a data.frame stored inside metadata slot.
}
\description{
runScanpyFindMarkers
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyFindMarkers(sce, colDataName = "Scanpy_louvain_1" )
}
}
