% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFeatureSelection.R
\name{runFeatureSelection}
\alias{runFeatureSelection}
\title{Run Variable Feature Detection Methods}
\usage{
runFeatureSelection(inSCE, useAssay, method = "vst")
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useAssay}{Specify the name of the assay that should be used. Should use
raw counts for \code{"vst"} method, or a normalized assay for other methods.}

\item{method}{Specify the method to use for variable gene selection.
Options include \code{"vst"}, \code{"mean.var.plot"} or \code{"dispersion"}
from Seurat and \code{"modelGeneVar"} from Scran. Default \code{"vst"}}
}
\value{
The input \linkS4class{SingleCellExperiment} object that contains 
the computed statistics in the \code{rowData} slot
}
\description{
Wrapper function to run all of the feature selection methods 
integrated within the singleCellTK package including three methods from
Seurat (\code{"vst"}, \code{"mean.var.plot"} or \code{dispersion}) and the 
Scran \code{modelGeneVar} method.

This function does not return the names of the variable features but only 
computes the metrics, which will be stored in the \code{rowData} slot. To set
a HVG list for downstream use, users should call \code{\link{setTopHVG}} 
after computing the metrics. To get the names of the variable features, users
should call \code{\link{getTopHVG}} function after computing the metrics.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runFeatureSelection(mouseBrainSubsetSCE,
                                           "logcounts",
                                           "modelGeneVar")
}
\seealso{
\code{\link{runModelGeneVar}}, \code{\link{runSeuratFindHVG}},
\code{\link{getTopHVG}}, \code{\link{plotTopHVG}}
}
